<?php
// admin/header.php
session_start();

// Security check: only admin can access
if (!isset($_SESSION['admin_id'])) {
    header("Location: ../admin/login.php");
    exit();
}

// Optional page title
$pageTitle = $pageTitle ?? "Admin Dashboard";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?php echo htmlspecialchars($pageTitle); ?> | Datapoint Admin</title>

    <!-- Meta -->
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- CSS -->
    <link rel="stylesheet" href="../assets/css/admin.css">

    <!-- Favicon -->
    <link rel="icon" type="image/png" href="../assets/images/favicon.png">
</head>

<body>
    <!-- Top Header -->
    <header class="admin-header">
        <div class="logo">
            <img src="../assets/images/logo.png" alt="Datapoint Logo">
            <span>Datapoint Admin</span>
        </div>

        <div class="admin-info">
            <span>
                Welcome, 
                <?php echo htmlspecialchars($_SESSION['admin_name'] ?? 'Admin'); ?>
            </span>
            <a href="logout.php" class="logout-btn">Logout</a>
        </div>
    </header>

    <!-- Main Wrapper -->
    <div class="admin-wrapper">